<?php
/*
Plugin Name: WP Quiz Generator Plugin
Plugin URI: http://sawa-s.com/wp-quiz-generator/
Description: 複数の４択クイズを作成し実行できるプラグインです。
Version: 1.0
*/

// 管理画面にメニュー追加
add_action('admin_menu', function(){
    add_menu_page(
		'クイズジェネレータ'
		, 'クイズジェネレータ'
		, 'manage_options'
		, 'quzgenerator_menu'
		, 'quzgenerator_mainmenu_page_contents'
		, 'dashicons-games'
		, 65
	);
});
function quzgenerator_mainmenu_page_contents() {
	$iddiv="<h2>作成済みのクイズID（更新日順）、クリックするとこのIDで読み込みします。</h2>";
	$pdir = plugin_dir_path( __FILE__ ) . "data/";
	$pjs = $pdir . "*.js";
	$sort_by_last_modify = function($a, $b){
 	   return filemtime($b) - filemtime($a);
	};
	$id_files = glob($pjs);
	usort($id_files, $sort_by_last_modify);
	foreach ($id_files as $value) {
		$str = str_replace($pdir, '', $value);
		$str = str_replace('quiz-', '', $str);
		$str = str_replace('.js', '', $str);
		if ($str != "defalt"){
			$iddiv .= "<button type='submit' class='button-primary' form='form1' id='$str' onclick=\"jQuery('#read-file').val('$str');\" style='font-size:20px;padding:10px;'>$str</button>&nbsp;&nbsp;";
		}
	}

	$purl = plugin_dir_url( __FILE__ );
	echo <<< EOM
<h2 style="font-size:26px;">クイズの新規作成と読み込み</h2>
<div style="font-size:16px;color:#000;">
<form method="post" id="form1" action="${purl}quiz-editor.php" target="_blank">
<input type="hidden" name="action" value="read">
<input type="hidden" name="pw" value="wpquizgen1">

<p style="font-size:16px;color:#000;">読み込むクイズID（半角英数）を記入してください。<br>新たにクイズを作成する場合も記入してください。（例：quiz001・kanjiquiz1など)</p>
   <input type="text" id="read-file" name="quiz-id"  pattern="^[0-9a-zA-Z]+$" placeholder="クイズID(半角英数字のみ)" required style="padding:8px;font-size:20px;"><br>&nbsp;<br>

<input id="new-quiz" name="new-quiz" type="checkbox" value="new"> 新規作成の場合はチェックしてください。既定値で読み込みます。<br>&nbsp;<br>

<p style="font-size:16px;color:#000;">クリックするとクイズエディタが新しいタブで開きます。</p>
<input type="submit" class="button-primary" value="設定ファイル読み込み ・ 新規作成"  style="font-size:20px;">

</form>
</div>
<div>$iddiv</div>
EOM;
}

// ショートコードでクイズ呼び出し
function quiz_Func( $atts ) {
  extract ( shortcode_atts ( array (
		'id' => '',
		'width' => '500',
		'height' => '480'
	), $atts ) );

	$iframe_tag="";
	$purl = plugin_dir_url( __FILE__ );
	if ($id != ""){
	$iframe_tag="<iframe src='${purl}quiz-generator.php?quiz-id=${id}' style='width:${width}px;height:${height}px;border:none;overflow:hidden;'></iframe>";
	}

	return $iframe_tag;
}
add_shortcode('quiz', 'quiz_Func');

?>
