<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<title>Quiz Generator クイズ エディタ</title>
<meta http-equiv="Content-Style-Type" content="text/css">
<meta http-equiv="Content-Script-Type" content="text/javascript">
<style  type="text/css">
<!--
body{
	background:#EEE;
}
#contents{
	margin:0 auto;
	width:800px;
	padding:20px;
	background:#FFF;
	border:1px solid #333;
	font-size:17px;
	font-family: "メイリオ","Meiryo","ヒラギノ角ゴ Pro W3","Hiragino Kaku Gothic Pro","ＭＳ Ｐゴシック", "MS P Gothic","Osaka",Verdana,Arial, Helvetica, sans-serif;
}
h1 {
	padding: 0.5em;
	color: #010101;
	background: #eaf3ff;
	border-bottom: solid 3px #516ab6;
	text-align:center;
	font-size:24px;
}
h2 {
	color: #010079;
	text-shadow: 0 0 5px white;
	padding: 0.3em 0.5em;
	background: -webkit-repeating-linear-gradient(-45deg, #cce7ff, #cce7ff 3px,#e9f4ff 3px, #e9f4ff 7px);
	background: repeating-linear-gradient(-45deg, #cce7ff, #cce7ff 3px,#e9f4ff 3px, #e9f4ff 7px);
	font-size:20px;
}
.config-editor{
	width: 100%;
	margin:0 auto;
	border: 1px solid #9c9c9c;
	padding: 20px 50px;
	box-sizing: border-box;
}
.item{
	margin-bottom: 10px;
}
.label_left{
	display: block;
	width:100%;
	border-left: solid 10px #5250e0;
	border-bottom: solid 1px #5250e0;
	background-color:#EFF;
	padding-left: 15px;
	font-size:23px;
	margin-bottom:10px;
 }
.label2{
	display: block;
	width:95%;
	border-left: solid 3px red;
	border-bottom: solid 1px red;
	padding-left: 15px;
	font-size:20px;
	margin-bottom:10px;
	background-color:#FFE;
}
.config-editor input[type="text"] {
	padding: 10px;
	font-size:18px;
	font-family: "メイリオ","Meiryo","ヒラギノ角ゴ Pro W3","Hiragino Kaku Gothic Pro","ＭＳ Ｐゴシック", "MS P Gothic","Osaka",Verdana,Arial, Helvetica, sans-serif;
}
textarea{
	padding: 10px;
	height: 100px;
	font-size: 16px;
	font-family: "メイリオ","Meiryo","ヒラギノ角ゴ Pro W3","Hiragino Kaku Gothic Pro","ＭＳ Ｐゴシック", "MS P Gothic","Osaka",Verdana,Arial, Helvetica, sans-serif;
	width: 95%;
}
.config-editor textarea{
	padding: 10px;
	height: 100px;
	font-size: 16px;
	width: 95%;
} 
.config-editor select{
	height: 35px;
	width: 65%;
}
button,input[type="submit"]  {
	display : inline-block;
	border-radius : 5%;
	font-size : 18px;
	text-align : center;
	cursor : pointer;
	padding : 12px 12px;
	margin:10px;
	background : #000066;
	color : #ffffff;
	line-height : 1em;
	transition : .3s;
	box-shadow : 6px 6px 3px #666666;
	border : 2px solid #000066;
}
button:hover,input[type="submit"]:hover {
	box-shadow : none;
	color : #000066;
	background : #ffffff;
}
.desp {
	font-size:16px;
}
.qary{
	width:100%;
	margin: 10px;
	padding:10px;
	border:2px solid navy;
	background:#eff;
}
table.chikan{
	margin:1em 3em;
	width:600px;
	border:2px solid #000;
	border-collapse:collapse;
}
table.chikan th{
	padding:5px;
	border:1px dotted #000;
	background-color:#ccc;
	font-size:15px;
	line-height:15px;
	font-weight:bold;
}
table.chikan td{
	padding:5px;
	border:1px dotted #000;
	background-color:#fff;
	font-size:13px;
	line-height:20px;
	font-weight:normal;
}
table.chikan td.tag{
	font-size:14px;
	font-weight:bold;
	white-space:nowrap;
}
#q-config-gr,#copybtn,#quizexe-btn{
	display:none;
}
#htmltag{
	display: none;
	width: 95%;
	height: 3em;
	font-size:18px;
	background-color: #fffacd;
	border: 2px solid #191970;
	overflow: auto;
	padding: 10px;
}
#quiz-execution {
	display:none;
	width:100%;
	margin:20px;
}
-->
</style>
<script type="text/javascript" src="jquery-3.6.0.min.js"></script> 
<?php
if($_SERVER["REQUEST_METHOD"] == "POST"){
	$pass = $_POST['pw'];
	$action = $_POST['action'];
	if ($pass != "wpquizgen1"){
		htmlhead();
		echo "<script>alert('クイズ呼び出しエラー');</script>";
	} else {
		if ($action == "read"){
			$quizid = $_POST['quiz-id'];
			if(isset($_POST['new-quiz'])){
				$newquiz = $_POST['new-quiz'];
			}else {$newquiz ="";}

			$rfile=$quizid;
			if ($newquiz == "new"){
				$rfile="defalt";
			}
			$jsfile="data/quiz-$rfile.js";
			if (file_exists($jsfile)) {
				readdata();
			}else {
				htmlhead();
				echo "<script>alert('クイズファイルが見つかりません。');</script>";
			}
		}
	}
}
else{
	htmlhead();
	echo "<script>alert('クイズ呼び出しエラー');</script>";
}

function htmlhead(){
		echo <<< EOM
</head>
<body>
<div id="contents">
<h1>Quiz Generator クイズ エディタ</h1>
EOM;
}


function readdata(){
	$quizid = $_POST['quiz-id'];
	if(isset($_POST['new-quiz'])){
		$newquiz = $_POST['new-quiz'];
	}else {$newquiz ="";}

	$rfile=$quizid;
	if ($newquiz == "new"){
		$rfile="defalt";
	}
	$jsfile="data/quiz-$rfile.js";
	$cssfile="data/quiz-$rfile.css";
	$csstext = file_get_contents($cssfile);
	echo <<<EOM
<script type="text/javascript" src="$jsfile"></script>
<script type="text/javascript"><!--
// 初期設定
var qno=0;
var eno=0;
$(function() {

	$('#q-config-dsp').show();
	$('#q-config-gr').show();
	$('#copybtn').hide();
	$('#tagcopy').hide();
	$('#tagexe').hide();

	$('#qtitle').val(q_title);
	$('#qwidth').val(q_w);
	$('#qheight').val(q_h);
	$('#omsg').val(opening_msg.join('\\n'));
	$('#ostart').val(opening_start_button);
	$('#qno').val(q_no);
	$('#qdtime').val(q_dtime);
	$('#qtimer').val(q_timer);
	$("#qrnd"+q_rnd).attr("checked", true);
	$("#qdsp"+q_dsp).attr("checked", true);
	$('#qdtime').val(q_dtime);
	$("#qsound"+q_sound).attr("checked", true);
	$("#qsfl"+q_sfl).attr("checked", true);
	$('#imgfile0').val(img_file[0]);
	$('#imgfile1').val(img_file[1]);
	$('#soundfile0').val(sound_file[0]);
	$('#soundfile1').val(sound_file[1]);
	$('#rstart').val(restart_button);

	var queshtml="";
	qno=questions.length;

	for (i=0; i<questions.length; i++){
		j=i+1;
		var questemp = '<div class="qary"><label class="label2" for="ques' + i +'">問題' + j + '</label>問題：<input type="text" id="ques' + i + '" size="55" value="' + questions[i][0] + '"><br>回答群：<br>';

		var b=0;
		for (a=1; a<=6; a++){
			if (questions[i][1][a-1] === undefined){
				var kaitou="";
			}else {
					var kaitou=questions[i][1][a-1];
			}
			questemp += a + ':<input type="text" id="ans' + i + '-' + a + '" size="25" value="'  + kaitou + '">　';
			b ++;
			if (b == 2){
				b=0;
				questemp += '<br>';
			}
		}
		questemp += '正解番号：<input type="text" id="sno' + i + '" size="1" value="' + questions[i][2] + '">　得点：<input type="text" id="tk' + i + '" size="3" value="' + questions[i][3] + '"></div>';

		queshtml += questemp;
	}
	$("#ques-area").html(queshtml);

	var endhtml="";
	eno=endings.length;
	for (i=0; i<endings.length; i++){
		j=i+1;
		var endtemp = '<div class="qary">分岐点数：<input type="text" id="end' + i +'" size="1" value="' + endings[i][0] + '"><br>メッセージ<br><textarea id="enmsg' + i + '" rows="6" cols="70">' + endings[i][1].join('\\n') + '</textarea></div>';
		endhtml += endtemp;
	}

	$("#ending-area").html(endhtml);

// クイズファイルの生成
	$('#config-generation').on('click', function(){
		$('#quiz-execution').hide();
		$('#copybtn').hide();
		$('#tagcopy').hide();
		$('#tagexe').hide();

		q_title = $('#qtitle').val();
		q_w = $('#qwidth').val();
		q_h = $('#qheight').val();

		opening_start_button = $('#ostart').val();
		q_no = Number($('#qno').val());
		q_dtime = Number($('#qdtime').val());
		q_timer = Number($('#qtimer').val());
		q_sfl = Number($("input[name='qsfl']:checked").val());
		q_rnd = Number($("input[name='qrnd']:checked").val());
		q_dsp = Number($("input[name='qdsp']:checked").val());
		q_sound = Number($("input[name='qsound']:checked").val());
		img_file = [$('#imgfile0').val() , $('#imgfile1').val()];
		sound_file = [$('#soundfile0').val() , $('#soundfile1').val()];
		restart_button = $('#rstart').val();

		var csstext = $('#costumcss').val().replace(/\\r\\n|\\r/g, "\\n");

		var tmsg = $('#omsg').val().replace(/\\r\\n|\\r/g, "\\n");
		var lines = tmsg.split( '\\n' );
		var outArray = new Array();
		for ( var i = 0; i < lines.length; i++ ) {
			outArray.push( lines[i] );
		}
		opening_msg =  outArray;

		var nqArray = new Array();
		for (var i=0; i<qno; i++){
			var j=i+1;
			var nques = $('#ques' + i).val();
			if (nques == ""){ break; }
			var nsno = Number($('#sno' + i).val());
			var ntk = Number($('#tk' + i).val());

			var naArray = new Array();
			for (a=1; a<=6; a++){
				var b = a - 1;
				var anstxt = $('#ans' + i + '-' + a).val();
				if (anstxt == ""){ break; }
				naArray[b] = anstxt;
			}
			nqArray[i] = [nques,naArray,nsno,ntk];
		}
		questions = nqArray;

		var neArray = new Array();
		var mintk = 100;
		for (var i=0; i<eno; i++){
			var nend = Number($('#end' + i).val());
			if (mintk == 0){ break; }
			mintk = nend;

			var tmsg = $('#enmsg' + i).val().replace(/\\r\\n|\\r/g, "\\n");
			var lines = tmsg.split( '\\n' );
			var endArray = new Array();
			for ( var a = 0; a < lines.length; a++ ) {
				endArray.push( lines[a] );
			}
			neArray[i] = [nend,endArray];
		}
		endings = neArray;

		var nconfig = '/*===================================\\n * Quiz Generator v4.0 クイズファイル\\n * Copyright  Sawa\'s Factory\\n * http://sawa-s.com/quiz-generator-v4/\\n===================================*/\\n\\n/* ========= オープニング&クイズ設定	========= */\\nvar q_title = "' + q_title + '";\\nvar q_w = ' + q_w + ';\\nvar q_h = ' + q_h + ';\\nvar opening_msg=[\\n';

		var omvalue="";
		var i = 0;
		opening_msg.forEach(function(element){
			if ( i > 0 ){omvalue += ',\\n';}
			omvalue += '"' + element + '"';
			i ++;
		});

		nconfig += omvalue + '];\\nopening_start_button = "' + opening_start_button + '";\\nvar q_no = ' + q_no + ';\\nvar q_rnd = ' + q_rnd + ';\\nvar q_dsp = ' + q_dsp + ';\\nvar q_dtime = ' + q_dtime + ';\\nvar q_sound = ' + q_sound + ';\\nvar q_timer = ' + q_timer + ';\\nvar q_sfl = ' + q_sfl + ';\\nvar img_file = ["' + img_file[0] + '","' + img_file[1] + '"];\\nvar sound_file = ["' + sound_file[0] + '","' + sound_file[1] + '"];\\nvar questions = [\\n';

		var qsvalue="";
		for (i=0; i<questions.length; i++){
			j=i+1;
			if (i > 0){ qsvalue += ','; }
			qsvalue += '["' + questions[i][0] + '", \\n';
			var anvalue ="[";
			for (z=0; z<questions[i][1].length; z++){
				if (z > 0){ anvalue += ' , '; }
				anvalue += '"' + questions[i][1][z] + '"';
			}
			qsvalue += anvalue+ '], ' + questions[i][2] + ', ' + questions[i][3] +']\\n';
		}
		nconfig += qsvalue + '];\\n/* ==== エンディング ==== */\\nvar endings = [\\n';

		var edvalue="";
		for (i=0; i<endings.length; i++){
			j=i+1;
			if (i > 0){ edvalue += ','; }
			edvalue += '[' + endings[i][0] + ',[\\n';

			var emvalue="";
			var a = 0;
			endings[i][1].forEach(function(element){
				if ( a > 0 ){emvalue += ',';}
				emvalue += '"' + element + '"\\n';
				a ++;
			});
			edvalue += emvalue + ']]\\n';
		}
		nconfig += edvalue + '];\\nvar restart_button = "' + restart_button + '";\\n';

		$.ajax({
			type: 'POST',
			url: 'regist.php',
			data: {
				'id' : "$quizid",
				'js' : nconfig,
				'css' : csstext
			},
			success: function(data) {
				alert(data);
				$('#quizexe-btn').show();
			}
		});
	});

// 問題欄を追加
	$('#ques-add').on('click', function(){
		qno ++;
		var znum=qno-1;
		var temp = '<div class="qary"><label class="label2" for="ques' +znum +'">問題' + qno + '</label>問題：<input type="text" id="ques' + znum + '" size="55" value=""><br>回答群：<br>';

		var b=0;
		for (a=1; a<=6; a++){
			temp += a + ':<input type="text" id="ans' + znum + '-' + a + '" size="25" value="">　';
			b ++;
			if (b == 2){
				b=0;temp += '<br>';
			}
		}
		temp += '正解番号：<input type="text" id="sno' + znum + '" size="1" value="1">　得点：<input type="text" id="tk' + znum + '" size="3" value="9"></div>';

		$("#ques-area").append(temp);
	});

// エンディング 分岐メッセージ追加
	$('#ending-add').on('click', function(){
		eno ++;
		var enm = eno - 1;
		var temp = '<div class="qary">分岐点数：<input type="text" id="end' + enm +'" size="1" value="0"><br>メッセージ<br><textarea id="enmsg' +enm + '" rows="6" cols="70"><span class=\'msg_tokuten\'>あれ、わざと間違えたのかな。</span>\\n<span class=\'msg_tokuten\'>あなたの得点は <strong>!tokuten!点</strong> でした。</span>\\n\\n正解数は!seikai_num!問、正解率は!percent!％です。\\n再挑戦をお待ちしています。</textarea></div>';

		$("#ending-area").append(temp);
	});

// 作成したクイズを実行
	$('#quizexe-btn').on('click', function(){
				$('#tagcopy').show();
				$('#tagexe').show();
				$('#copybtn').show();
			var url= location.href;
			url = url.replace('/quiz-editor.php', '');
		fwidth = Number($('#qwidth').val()) + 4;
		fheight = Number($('#qheight').val()) + 4;
		iframetag="<iframe src='quiz-generator.php?quiz-id=$quizid' style='width:" + fwidth +"px;height:" + fheight + "px;border:none;overflow:hidden;'></iframe>";
		iframetag2="[quiz id='$quizid' width=" + fwidth +" height=" + fheight + "]";
		iframetag2 = iframetag2.replace(/'/g, '"');

		$("#quiz-execution").html(iframetag).show();
		$("#htmltag").text(iframetag2).show();
	});

	$('#copybtn').on('click', function(){
		let text = $('#htmltag').text();
		let \$textarea = $('<textarea></textarea>');
		\$textarea.text(text);
		$(this).append(\$textarea);
		\$textarea.select();
		document.execCommand('copy');
		\$textarea.remove();
		alert("クリップボードにコピーしました。\\n固定・投稿ページに貼り付けてください。");
	});

});


//--></script>
EOM;

	htmlhead();

	echo <<<EOM
<h2>クイズの設定</h2>
<div  id="q-config-dsp">

<div class="config-editor">

<div class="item">

<label class="label_left" for="qtitle">クイズＩＤ</label>
<p style="font-size:26px;">$quizid</p>

<label class="label_left" for="qtitle">クイズタイトル</label>
<input type="text" id="qtitle" size="30" value="４択クイズ" required>
<br><p class="desp">クイズのタイトルを記述してください。</p></div>

<div class="item">
<label class="label_left" for="name">クイズボックスの横幅 縦幅</label>
横幅：<input type="text" id="qwidth" size="3"> px　 縦幅：<input type="text" id="qheight" size="3"> px
<br><p class="desp">クイズボックスの横幅と縦幅をピクセル数で記述。<br>縦幅は選択数の増減によって調整してください。</p>
</div>

<div class="item">
<label class="label_left" for="omsg">オープニングメッセージ</label>
<textarea id="omsg" rows="5" cols="60"></textarea>
<br><p class="desp">オープニングメッセージを記述してください。適宜、改行を入れてください。<br>HTMLタグ・スタイルを指定できます。<br>スタイル指定時、ダブルクォーテーションは使えません。スタイルなど書く時はシングルクォーテーション(見本 &lt;span style='font-size:24px;'&gt;)を使ってください。</p>
</div>

<div class="item">
<label class="label_left" for="ostart">スタートボタン名</label>
<input type="text" id="ostart" size="10">
</div>

<div class="item">
<label class="label_left" for="qno">出題数</label>
<input type="text" id="qno" size="5">
<br><p class="desp">出題数を記述。問題数より少なくても可。多いとエラーになる。<br>問題数が20問、出題数が10問、ランダム出題の場合、問題の中からランダムに10問出題されます。ランダムですので毎回出題内容が変わります。<br>問題20問、出題10問、昇順出題の場合は先頭から10問が出題され、残りの10問は出題されません。</p>
</div>

<div class="item">
<label class="label_left" for="qrnd">出題順</label>
<input type="radio" id="qrnd0" name="qrnd" value="0">昇順 <input type="radio" id="qrnd1" name="qrnd" value="1">ランダム
 <p class="desp">一度出題した問題は再出題（重複）しません。</p></div>



<div class="item">
<label class="label_left" for="qdsp">正解・不正解の表示</label>
<input type="radio" id="qdsp0" name="qdsp" value="0">しない <input type="radio" id="qdsp1" name="qdsp" value="1">する
</div>

<div class="item">
<label class="label_left" for="qdtime">正解・不正解を表示する場合、表示する秒数</label>
<input type="text" id="qdtime" size="5">

</div>

<div class="item">
<label class="label_left" for="qsound">正解・不正解を表示する場合、サウンドを使用</label>
<input type="radio" id="qsound0" name="qsound" value="0">しない <input type="radio" id="qsound1" name="qsound" value="1">する
<br><p class="desp">使用するにした場合、オープニングメッセージに「※注：音が出ます。」と追加表示されます。</p></div>

<div class="item">
<label class="label_left" for="qtimer">制限時間（秒） 0-設定なし</label>
<input type="text" id="qtimer" size="5">
<br><p class="desp">制限時間を設定するとカウントダウンします。時間切れの場合は不正解となり、次の問題に進みます。</p>
</div>

<div class="item">
<label class="label_left" for="qsfl">回答群をシャッフル</label>
<input type="radio" id="qsfl0" name="qsfl" value="0">しない <input type="radio" id="qsfl1" name="qsfl" value="1">する
<br><p class="desp">回答群をランダムに入れ替え表示することができます。シャッフルするに設定しておけば、回答１番目に正解を置く事が出来ますので、問題数が多い場合には書きやすいと思います。</p></div>

<div class="item">
<label class="label_left" for="imgfile">正解・不正解を表示する 画像ファイル</label>
不正解画像：<input type="text" id="imgfile0" size="20"><br>
正解画像　：<input type="text" id="imgfile1" size="20">
<br><p class="desp">正解・不正解を表示する画像ファイルを入れ替える場合のみ変更してください。<br>
画像ファイルをフォルダに入れる場合はフォルダ名も指定してください。<br>例：image/fuseikai.png image/seikai.png"];<br>画像は透過PNGまたは透過GIFを使った方が綺麗です。URL(http://~)での指定も可。</p>
</div>

<div class="item">
<label class="label_left" for="soundfile">サウンドを鳴らす場合のサウンドファイル </label>
不正解サウンド：<input type="text" id="soundfile0" size="20"><br>
正解サウンド　：<input type="text" id="soundfile1" size="20">
<br><p class="desp">サウンドファイルはWAV,MP3などaudioタグで動作するものを指定してください。またサウンドファイル先読みしますが、サイズが小さいほうが良いでしょう。URL(http://~)での指定も可。</p>
</div>


<div class="item">
<label class="label_left" for="ques">問題・回答群・得点の入力</label>
<p class="desp">問題はタグ・スタイルが使用可能です。<br>問題文にダブルクォーテーションは使えません。スタイルなど書く時はシングルクォーテーション(見本 &lt;span style='font-size:24px;'&gt;)を使ってください。<br>正解番号は回答群の数値を入れてください。<br>
得点は任意の数字を書いてください。全て10でもOKです。例えば、簡単な問題がある場合、他の問題が10なら2とすることが出来ます。逆に難しい問題は15とする事ができます。これは難しい問題を正解した場合は得点が高くなるという事です。お好きなように得点を配分してください。<br>使用しない回答群は空欄にして、１から詰めて記入してください。</p>

<div id="ques-area"></div>

<button id="ques-add">問題を追加</button>

<p class="desp">問題を追加をクリックすると問題が増えます。<br>問題を使わない場合は問題欄を空欄にしてください。<br>問題が空欄以降の問題は書いてあっても使用しません。上から詰めて記入してください。<br>回答群も空欄は使用せず、１から詰めて記入してください。</p>

</div>

<hr>
<div class="item">
<label class="label_left" for="ques">エンディングの設定</label>
<p class="desp">分岐得点は分岐させる得点を書いてください。総得点がこの得点以上の場合、エンディングメッセージを決めています。例は5個ですが幾つでも書くことが出来ます。例えば3つで90,50,0、6つで100,85,50,35,20,0など。必ず最後は0になるようにしてください。最初は100でなくても構いません。90ならば総得点が90点以上のメッセージになります。<br>
エンディングメッセージにはその分岐点数に合ったメッセージを記入してください。タグ・スタイルを指定できます。<br>スタイル指定時、ダブルクォーテーションは使えません。スタイルなど書く時はシングルクォーテーション(見本 &lt;span style='font-size:24px;'&gt;)を使ってください。<br>&nbsp;<br>
エンディングメッセージには以下の文字列（! !を先頭と最後に入れる）を含めることで置換されます。これら全てを使わなくても構いません。どれを使うかはあなたが判断してください。</p>
<table class="chikan">
<tr><th style="width:150px;">置換文字列</th><th style="width:100px;">名称</th><th>解説</th></tr>
<tr><td class="tag">!tokuten!</td><td>得点</td><td>得点が入ります。</td></tr>
<tr><td class="tag">!seikai_num!</td><td>正解数</td><td>正解数が入ります。</td></tr>
<tr><td class="tag">!percent!</td><td>正解率(%)</td><td>正解数÷出題数×100を四捨五入した値が入ります。</td></tr>
</table>

<div id="ending-area"></div>
<button id="ending-add">分岐メッセージを追加</button>
<p class="desp">分岐メッセージを追加をクリックすると分岐メッセージ欄が増えます。<br>分岐点数は上から大きい順に並べて上から詰めて書いてください。最後は必ず0になるように記入してください。<br>使わない欄がありましたら分岐点数を0にしておいてください。</p><br>
</div>

<div class="item">
<label class="label_left" for="rstart">リスタートボタン名</label>
<input type="text" id="rstart" size="30" value="再挑戦する">
<br><span class="desp">空白にするとボタンを非表示にする事ができます。</span></div>

<div class="item">
<label class="label_left" for="rstart">CSSカスタマイズ</label>
<p class="desp">クイズ毎にスタイルシートをカスタマイズできます。<br>変更可能な要素を書いてあります。コメント部分は削除可です。</p>
<textarea id="costumcss" rows="9" cols="60" style="width:95%;height:500px;">$csstext</textarea>
</div>

</div>
</div><!-- q-config-dsp -->

<!-- ファイルの生成 -->
<h2 id="q-seisei">クイズファイルの生成・保存</h2>
<div id="q-config-gr">
<button id="config-generation">クイズファイルの生成・保存</button><br>
<p class="desp">「クイズファイルの生成・保存」をするとクイズの実行ができます。<br>クイズの設定・問題などを変更した時も生成・保存をクリックしてください。</p>
</div>

<h2>作成したクイズを実行</h2>
<button id="quizexe-btn">作成したクイズを実行＆ショートコード生成</button>
<div id="quiz-execution"></div>
<div id="tagexe">
<p class="desp">クイズの修正をした場合はキャッシュが残って更新されない場合があります。<br>その場合はブラウザのキャッシュをクリアして再実行してください。</p>
</div>
<h2>固定・投稿ページへ貼り付けるショートコード</h2>
<div id="tagcopy">
<p class="desp">コピーしてお使いください。</p>
<pre id="htmltag"></pre>
</div>
<button id="copybtn">ショートコードをクリップボードにコピー</button>
EOM;
}
?>

<div style="width:100%;text-align:right;font-size:15px;">Created by <a href='http://sawa-s.com/' target='_blank'>Sawa's Factory</a></div>
</div>
</body>
</html>
